#include <chrono>
#include <vector>
#include <string>
#include <ctime>
#include <cstdlib>
#include <mutex>
#include <thread>
#include <sstream>
#include <iostream>

#include "MyMonitor.hpp"

#include "thrift/gen-cpp/Monitoring.h"
#include <thrift/server/TThreadedServer.h>
#include <thrift/transport/THttpServer.h>
#include <thrift/transport/THttpTransport.h>
#include <thrift/protocol/TJSONProtocol.h>
#include <thrift/transport/TServerSocket.h>

using namespace ::apache::thrift;
using namespace ::apache::thrift::protocol;
using namespace ::apache::thrift::transport;
using namespace ::apache::thrift::server;
using namespace std;

mutex MyMonitor::_farmMu;
FarmerInfo MyMonitor::_farmInfo;

// =====================================================================
void MonitoringHandler::get(FarmerInfo & _return) {
	MyMonitor::_farmMu.lock();
	_return = MyMonitor::_farmInfo;
	MyMonitor::_farmMu.unlock();
}

// =====================================================================
void MyMonitor::srvRoutine() {
	int port = 65000;
	boost::shared_ptr<MonitoringHandler> handler(new MonitoringHandler());
	boost::shared_ptr<TProcessor> processor(new MonitoringProcessor(handler));
	boost::shared_ptr<TServerSocket> serverSocket(new TServerSocket(port));
	boost::shared_ptr<TTransportFactory> transportFactory(new THttpServerTransportFactory());
	boost::shared_ptr<TProtocolFactory> protocolFactory(new TJSONProtocolFactory());
	_server = new TThreadedServer(processor, serverSocket, transportFactory, protocolFactory);
	_server->serve();
}

// =====================================================================
MyMonitor::MyMonitor(int intervallMs, FarmerInfo farmInfo) {
	MyMonitor::_farmInfo = farmInfo;
	_intervall = intervallMs;
	thread srv = thread(&MyMonitor::srvRoutine, this);
	srv.detach();
}

// =====================================================================
MyMonitor::~MyMonitor() {
	_server->stop();
}

// =====================================================================
void MyMonitor::log(
	int runWorker,
	vector<string> runningJobs,
	int & allWorker,
	long long & duration,
	string best,
	Configurator conf,
	vector<long> jobs,
	vector<long> timeouts,
	vector<int> mem
) {

	MyMonitor::_farmMu.lock();
	MyMonitor::_farmInfo.runWorker   = runWorker;
	MyMonitor::_farmInfo.runningJobs = runningJobs;
	MyMonitor::_farmInfo.allWorker = allWorker;
	MyMonitor::_farmInfo.duration  = duration;
	MyMonitor::_farmInfo.best      = best;
	MyMonitor::_farmInfo.conf      = conf;
	MyMonitor::_farmInfo.jobs      = jobs;
	MyMonitor::_farmInfo.timeouts  = timeouts;
	MyMonitor::_farmInfo.mem       = mem;
	MyMonitor::_farmMu.unlock();

	time_t now = time(0);
	struct tm tstruct = *localtime(&now);
	char nowStr[80];
	strftime(nowStr, sizeof(nowStr), "%d.%m.%Y (%H:%M:%S)", &tstruct);
	int js  = jobs.size();
	int tou = timeouts.size();
	int rs  = runningJobs.size();
	ostringstream osConf;
	osConf << conf;
	
	fprintf(
		stderr,
		"Worker %d / %d, "
		"Duration %lld s, "
		"Best %s, "
		"Now %s, "
		"%s, ",
		runWorker,
		allWorker,
		duration,
		best.c_str(),
		nowStr,
		osConf.str().c_str()
	);

	fprintf(stderr, "MemoryUsage ( ");
	for(int w=0; w < allWorker; ++w)
		fprintf(stderr, "%d:%d ", w, mem[w]);

	fprintf(stderr, ") Running ( ");
	for(int w=0; w < rs; ++w)
		fprintf(stderr, "%d:%s ", w, runningJobs[w].c_str());
	
	fprintf(stderr, ") Open ( ");
	for(int i=0; i < js; ++i)
		fprintf(stderr, "%d:%ld ", i, jobs[i]);

	fprintf(stderr, ") Timeouts ");
	for(int i=0; i < tou; ++i)
		fprintf(stderr, "%d:%ld ", i, timeouts[i]);

	fprintf(stderr, "\n");
}
